//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help

//N.M.Collins 2 Feb 2006

//autonomous music agent, no GUI

//there will be one each for harpsichord and recorder, varying in their event detection mechanisms
//perhaps only estimate tempo/beats using the harpsichord as more reliable signal- or combine events from both

//how to reconcile key estimates, independent kitchs for recorder and harpsichord? or only pass if certain, ie both match 

Ornamaton {	
	var s;
	
	var <harpsichord, <recorder;
	//updateable predictions
	var nextbeat, period, tempo;
	
	var debugbuffer;
	
	var sourcegroup, analysisgroup, playgroup, fxgroup;
	var inbus1,inbus2, outbus;
	
	var density, hdensity, rdensity, activity, hactivity, ractivity, activityenvelope, startTime;
	
	//listening
	var kitch, key, kitchkey, kitchlistener, currentkey; 
	
	//can be zeroed from outside to control it or force an end
	var <>activitymult=1.0;
	
	//DEBUG
	//var <beats;
	
	*new {arg debug=0;
		^super.new.initOrnamaton(debug);
	}

	
	//
//	*new {arg bus, trigID, group, threshold=0.14, playgroup;
//		^super.new.initAgents(playgroup,bus, trigID, group,threshold)
//	}
	
	//do all setup within this
	
	
	initOrnamaton {arg debug;
		var condition, b;

		currentkey=0;

		//also see HackerDrummerTracker
		
		//debug version, always ornament
		//activityenvelope= Env.new([1,1],[60],'sine');
		
		//activityenvelope=Env.new([0,0,0.1,0,0.2,0,0.3, 0.1,0.4,0.2,0.5,0.0,0.7,0.2,1,0.25,1],[60,30,30,30,15,15,30,15,30,15,30,15,30,15,15,15],'sine');

//need bonus activity here to make exciting enough

		//This is effectively ornaments per second, hence multiplier
		activityenvelope=Env.new([0,0,0.1,0,0.2,0,0.3, 0.1,0.4,0.2,0.5,0.0,0.7,0.2,1,0.25,1]*2,[60,30,30,30,15,15,30,15,30,15,30,15,30,15,15,15],'sine');
	

//for demoes skipping first half? 
if(debug>3.5)
{activityenvelope=Env.new([0.3, 0.1,0.4,0.2,0.5,0.0,0.7,0.2,1,0.25,1]*2,[30,15,30,15,30,15,30,15,15,15],'sine');};


		condition= Condition.new;
			
		s=Server.default;
		
		Routine.run({
		
		sourcegroup=Group.head(RootNode.new);

		analysisgroup= Group.after(sourcegroup);

		playgroup= Group.after(analysisgroup);
		
		fxgroup=Group.after(playgroup);
		
		//audio ins unless debug
		inbus1=8;
		inbus2=9;
		
		outbus= 0;
		
		if(debug>0.5) {
		
		//b=[Buffer.read(s,"/Volumes/data/audio/danandinga/dan1.wav"),Buffer.read(s,"/Volumes/data/audio/danandinga/ingaonsets1.wav")];
		
		b=Buffer.read(s,"/Volumes/data/audio/danandinga/ornamaton.wav");

		s.sync(condition);	
		
		inbus1=0;
		inbus2=1;
		//
		//if(debug!=2) {
//		Synth.head(sourcegroup,\playbuftest,[\out,inbus1,\bufnum,b[0].bufnum]);
//		};
//		
//		if (debug!=1) {
//		Synth.head(sourcegroup,\playbuftest,[\out,inbus2,\bufnum,b[1].bufnum]); //to force stereo projection
//		};


//stereo playback, must hear both
		Synth.head(sourcegroup,\playbuftest2,[\out,inbus1,\bufnum,b.bufnum]);

		//Synth.head(sourcegroup,\playbuftest2debug,[\out,inbus1,\bufnum,b.bufnum]);



		};
		
		
		[\mode, debug, \inbus1,inbus1, \inbus2, inbus2].postln;
		
		Synth.head(fxgroup,\OrnamatonLimiter,[\inbus,outbus,\outbus, outbus]);

		//assumes inbus1, inbus2 contiguous
		kitch=Synth.head(analysisgroup,\OrnamatonKitch,[\inbus,inbus1,\trigID, 80]);
		
		kitchlistener= OSCpathResponder(s.addr,['/tr',kitch.nodeID, 80],{arg time,responder,msg;
		var latest; 
	
			latest=(msg[3]).asInteger;
			
			//[\kitchkey,latest].postln;
			
			kitchkey=(latest+1)%12; //+1 to compensate for 415 Hz baroque tuning reference
			
		}).add;
		

		harpsichord=OrnamatonInstrument(debug);
		recorder=OrnamatonInstrument(debug);
	
		//successive triggerIDs 77,78
		harpsichord.analyse(condition, inbus1, playgroup, analysisgroup,  \analyseharpsichorddatabase, 77, 0.14);
		
		//"analyzing".postln;
		//inbus2.postln;
		recorder.analyse(condition, inbus2, playgroup, analysisgroup,  \analyserecorderdatabase, 78, 0.3);
		
		s.sync(condition);	
		
		this.initListening;
		
		});
		
		

	}
	
	//adds to Tail
	initListening {
		
		//DEBUG
		//beats=List.new;
		
		startTime=Main.elapsedTime;
		
		period=0.5;
		tempo=2;
		nextbeat=startTime + period;

		//go straight away
		SystemClock.sched(0.0,{
			 var now, times1, times2, times, progress;
			 var events1, events2, events, pitches;
			//make an IOI histogram 10 times a second looking at last 2 seconds only for timing info
			
			now=Main.elapsedTime;
			
			//event times in last two seconds; combine instruments
			times1=harpsichord.database.findEventAbsoluteStarts(now-2,now);			times2=recorder.database.findEventAbsoluteStarts(now-2,now);		
			times= (times1++times2).sort;
			
			density=times.size;
			hdensity=times1.size;
			rdensity=times2.size;
			
			events1=harpsichord.database.findEventList(now-2,now);			events2=recorder.database.findEventList(now-2,now);		
			events= (events1++events2);
			
			//corrects from 415 EQT back to 440
			
			pitches= events.collect({arg val; (((val[7].cpsmidi)+1.012706247691995).round(1.0).asInteger)%12});
			
			//round to 415 base EQT  67.987293752308
			//Post << key << nl;
			
			//removes duplications
			this.analyseKey(pitches.asSet.asArray.sort);
			
			//key.postln;
			
			if(key==kitchkey,{currentkey=key;}); //if match, update
			
			//[\kitch, kitchkey,\discrete, key, currentkey].postln;
			
			//[times1.size,times2.size, times.size].postln;
			
			//times.postln;
			
			//at least three events to indicate a metre
			if ((density)>2,{
				this.analyseTimes(times, now);
				}, {
				//update predicted beat using current tempo and last beat time
				
				if (now>(nextbeat-0.1),{nextbeat=nextbeat+period; });
				
			});
			
			
			progress= (now-startTime);
			
			//0.1 compensates for the ten checks a second of this loop
			activity= 0.1*(activitymult)*(activityenvelope.at(progress));
			
			//inverse of density clipped, 10 events per 2 seconds as maximal, perhaps will change this
			hactivity=activity*(0.5*(1.0-min(hdensity/10,1))+1.0); //adds up to 50% extra chance if sparser than 10 events per sec
			ractivity=activity*(0.5*(1.0-min(rdensity/10,1))+1.0);
						
			//[\hdensity, hdensity,\hactivity,hactivity,\rdensity, rdensity,\ractivity,ractivity].postln;
						
			//[\activity,activity, \progress, progress].postln;
			
			//[now, nextbeat, tempo,harpsichord.ornamentplaying,recorder.ornamentplaying].postln;
			
		//	must have been an event in the last 2 seconds, also controlled from outside with multiplier
			if(((hactivity.coin) && (not(harpsichord.ornamentplaying)) && (hdensity>0.5)),{"ornament harpsichord".postln; harpsichord.compose(nextbeat, period,currentkey,progress); });
			
			if(((ractivity.coin) && (not(recorder.ornamentplaying))  && (rdensity>0.5)),{"ornament recorder".postln; recorder.compose(nextbeat, period, currentkey,progress); });
//	
	
			0.1
		});
		
		
	}
	
	
		
	analyseKey {arg pitches;
		var matches;
		
		matches=List.new;
		
		12.do({arg i; 
		var fail; 
		var testset;
		fail=false;
		
		testset= ([0,2,4,5,7,9,11]+i)%12;
		
		pitches.do({arg p; 
		
		var found=false; 
		
		testset.do({arg q; if(p==q,{found=true;});  });
		
		if(found==false,{fail=true;});
		
		});
		
		if(not(fail),{matches.add(i);});
		
		});
		
		//test all in this case
		if(matches.isEmpty,{matches=[0,1,2,3,4,5,6,7,8,9,10,11]});
		
		^key=this.scoreBestKey(pitches, matches);
	}
	
	scoreBestKey {arg pitches, keys;
		var besti,bestscore;
		var profile;
		
		profile= [ 0.15195022732711, 0.053362048336923, 0.083273510409189, 0.055754965302704, 0.10480976310122, 0.097870303900455, 0.060301507537688, 0.12419239052405, 0.057190715482173, 0.087580760947595, 0.054797798516391, 0.068916008614501 ];
		
		bestscore=0;
		besti=0;
		
		keys.do({arg i;
		var score;
		
		score=profile.rotate(i).at(pitches).sum;
		
		//[profile.rotate(i),profile.rotate(i).at(pitches), score].postln;
		
		
		if(score>bestscore,{bestscore=score; besti=i; });
	
		});
	
		^besti;
	}
	
	

//could also analyse how loose timing is to the inferred beat at the moment
//quantise to the beat etc

	
	//could be method of AED but done here for now
	//find tempo and predicted next beat
	
	//get tempo from overall IOI histogram test
	//get beat by assuming one of the events must be on beat, find event that best explains the others at given tempo
	
	analyseTimes {arg times, now;
		var hbins, maxind,maxval;
		
		//error in long term for assuming up to 2 bpm out, but in short term (next second) at most 2/60= 0.0333 beat 
		//80 to 160, every 4 bpm
		
		//bps 1.3333333333333/20
		//spb 0.375+ (0.375/20)
		//Array.series(21, 0.375, 0.01875).reciprocal*60
		//if store by time intervals rather than tempi get stretch automatically
		
		
		hbins= Array.fill(21,{arg i; 0.0});
		
		(times.size-1).do({arg i; 
			var t1,t2,wt;
			var interval, bin;
			
			t1=times[i];
			
			//linear drop over time for relevance
			wt= (2-(now-t1))/2;
			
			for(i+1,(times.size)-1,{arg j; 
				
				t2=times[j];
				
				//only count if in direct range of tempo determinants? 
				interval= t1-t2;
				
				//interval.postln;
				
				if((interval >0.75) && (interval> 2.0), {interval= interval*0.5;});
				
				if((interval <0.375) && (interval> 0.1), {interval= interval*2;});
				
				if((interval<0.75) && (interval>=0.375), {
				
				bin= ((interval-0.375)/0.01875).round(1.0).asInteger;
				
				hbins[bin]= hbins[bin]+ wt;
				
				});
				
			});
			
		});
		
		maxind=0;
		maxval=0.0;
		
		//could take second max too, beware ambiguity?
		
		hbins.do({arg val,i; if(val>maxval,{maxval=val; maxind=i;}); });
		
		//hbins.postln;
		
		period= 0.375+(maxind*0.01875);
		
		tempo=period.reciprocal;
	
		//60/(period).postln;
		
		////FIND PHASE under assumption that one collected event was on the eighth note beat level at least
		
		//find event which best explains others with period, lowest penalty score. 
		
		hbins= Array.fill(times.size,{arg i; 0.0});
		
		times.do({arg val, i; 
			var score;
			
			score=0.0;
			
			times.do({arg val2, j; 
			var diff;
			
				diff= ((val2-val).abs)/period;
				
				score= score + (abs(diff-(diff.round(0.5)))); //assumes from nearest quaver
			
			});
			
			hbins[i]=score;
			
		});
		
		maxind=0;
		maxval=100000.0;
		
		//could take second max too, beware ambiguity?
		
		hbins.do({arg val,i; if(val<maxval,{maxval=val; maxind=i;}); });
		
		nextbeat= times[maxind]+(period*(((now-times[maxind])/period).roundUp));
		
		//beats.add([Main.elapsedTime,nextbeat]);
		
		//[times[maxind],(now-times[maxind])/period, nextbeat].postln;	
	}
		
	
	*initClass {
	
		StartUp.add({
		
		SynthDef.writeOnce(\OrnamatonKitch,{arg inbus=0, outbus=0, trigID, decay=2.0;  
				var source;
				
				source=Mix(In.ar(inbus,2));
		
				Kitch.ar(source,trigID, decay); 
		
			});
	

	
			
		SynthDef.writeOnce(\OrnamatonLimiter,{arg inbus=0, outbus=0;  
				ReplaceOut.ar(outbus, Limiter.ar(In.ar(inbus,2),0.999,0.005));
			});
	});
		
	}
	
	
}